VERSION 5.00
Object = "{831FDD16-0C5C-11D2-A9FC-0000F8754DA1}#2.0#0"; "MSCOMCTL.OCX"
Begin VB.Form TK3disassembleMPASM 
   Caption         =   "TK3 Disassemble PIC program memory"
   ClientHeight    =   5985
   ClientLeft      =   60
   ClientTop       =   345
   ClientWidth     =   6285
   Icon            =   "TK3disassembleMPASM.frx":0000
   LinkTopic       =   "Form2"
   MaxButton       =   0   'False
   ScaleHeight     =   5985
   ScaleWidth      =   6285
   StartUpPosition =   2  'CenterScreen
   Begin VB.CommandButton cmdAbort 
      BackColor       =   &H0000FFFF&
      Caption         =   "Abort"
      Height          =   375
      Left            =   5640
      Style           =   1  'Graphical
      TabIndex        =   6
      ToolTipText     =   "Aborts the disassembly and close file at current line"
      Top             =   600
      Visible         =   0   'False
      Width           =   495
   End
   Begin VB.CommandButton Quit 
      BackColor       =   &H0000FF00&
      Caption         =   "OK"
      Height          =   375
      Left            =   5640
      Style           =   1  'Graphical
      TabIndex        =   2
      Top             =   120
      Visible         =   0   'False
      Width           =   495
   End
   Begin VB.ListBox List1 
      Height          =   4350
      Left            =   120
      TabIndex        =   1
      Top             =   1080
      Visible         =   0   'False
      Width           =   6015
   End
   Begin MSComctlLib.ProgressBar ProgressBar1 
      Height          =   255
      Left            =   120
      TabIndex        =   0
      Top             =   240
      Width           =   5415
      _ExtentX        =   9551
      _ExtentY        =   450
      _Version        =   393216
      Appearance      =   1
   End
   Begin VB.Label Label3 
      Alignment       =   2  'Center
      BackColor       =   &H0000FFFF&
      Caption         =   "Warning"
      Height          =   375
      Left            =   120
      TabIndex        =   5
      Top             =   5520
      Visible         =   0   'False
      Width           =   6015
   End
   Begin VB.Label Label2 
      Height          =   255
      Left            =   4560
      TabIndex        =   4
      Top             =   840
      Width           =   855
   End
   Begin VB.Label Label1 
      Alignment       =   2  'Center
      Caption         =   "QUICKVIEW LISTING"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   1800
      TabIndex        =   3
      Top             =   840
      Visible         =   0   'False
      Width           =   2895
   End
End
Attribute VB_Name = "TK3disassembleMPASM"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
'Toolkit Mk3 disassemble PIC to MPASM 16MAR05

Private Bank0, CheckSum
Private AddressVal1, AddressCode$, AddressCode2$, OrgVal, RegFlag(4096)
Private codevalue(255)
Dim AbortPressed As Boolean     ' ** Malc **

Private Sub cmdAbort_Click()    ' ** Malc **
AbortPressed = True
End Sub

Public Sub switchon()
Out Port1, 16: Call delay10
Out Port1, (8 Or 16): Call delay10: Out Port1, 16
End Sub

Public Sub switchoff()
Out Port1, 8: Call delay10: Out Port1, 0
End Sub

Public Sub switchon18F()
Out Port1, 16: Call delay10
Call delay10
Call delay10
End Sub

Public Sub switchoff18F()
Out Port1, 8: Call delay10: Out Port1, 0
End Sub

Public Sub delay10()
d = longdelay
delay11: t = Int(Timer): If d > 0 Then d = d - 1: GoTo delay11
End Sub

Public Sub delay1()
t = Timer: 'intentional short delay
End Sub

Private Sub disassemble(): 'disassemble PIC value
SendVal = 4: BitVal = 6: Call sendit: '$000100 "read program data" command
PICbyte = 0
For B = 15 To 0 Step -1: PICbyte = PICbyte \ 2
Call getbit: Next

'aj introduced condition 19Aug04
If Not PnM_LowPinCount() Then
SendVal = 8: BitVal = 6: Call sendit: '$001000 "prog accept" command
End If
'aj end 19Aug04

'sendval = 8: bitval = 6: Call sendit: '$001000 "prog accept" command ' prev 19Aug04
SendVal = 6: BitVal = 6: Call sendit: '$000110 "step address"
End Sub

Private Sub getbit()
Out Port1, (16 Or 2): ' 12V on, clk high
'Call delay1: ' deleted 18MAR05
Out Port1, 16: ' 12V on, clk low
'Call delay1:' deleted 18MAR05
E = Inp(Port2):  ' get bit
E = E And 64: If E <> 0 Then PICbyte = PICbyte Or 32768
End Sub

Public Sub sendit()
For C = BitVal To 1 Step -1
outval = SendVal And 1 Or 16: 'val plus clock high
Out Port1, (outval Or 2)
't = Timer: 'intentional delay  ' deleted 18MAR05
Out Port1, outval: 'val plus clock low
SendVal = SendVal \ 2: Next C
End Sub


Private Sub Form_Unload(Cancel As Integer)
Unload TK3disassembleMPASM
End Sub

Private Sub Quit_Click()
Quit.Visible = False
Label1.Caption = "QUICKVIEW LISTING"
List1.Clear: List1.Visible = False
Label1.Visible = False
Label2.Visible = False
ProgressBar1.value = 1
TK3disassembleMPASM.Cls
Unload TK3disassembleMPASM
End Sub

Public Sub MPASMhexit() ' PIC to HEX disasm
On Error GoTo showerror

If Left$(PICdevice, 6) = "PIC18F" Then Call MPASMhexit18F: Exit Sub

If PICpath <> 10 Then PICpath = 12

FileName = "PICDECODE.HEX"
inputfile(12) = "PICDECODE.HEX"

'blank$ = "00000000000000000000000000000000"
blank$ = "FF3FFF3FFF3FFF3FFF3FFF3FFF3FFF3F"

Quit.Visible = False
List1.Clear: List1.Visible = False
Label1.Visible = False
Label2.Visible = False

TK3disassembleMPASM.Cls
TK3disassembleMPASM.Show

ProgressBar1.Visible = True
ProgressBar1.Min = 1
ProgressBar1.Max = PICsize + 1
Cls
Print Tab(3); "Downloading " & PICdevice & " to "; FileName & " Commands = " & PICsize

For A = 100 To PICsize + 100: ma(A) = 0: Next
Call switchon:
OpenFile = FileName
Open FileName For Output As #4
OpenFile = ""

hexif$ = "00": hexic$ = "": hexiD$ = "": hexD = 0
nn = 0: aaaa = 0: RR$ = "00"
Counter2 = 0

For Counter = 0 To PICsize - 1
ProgressBar1.value = Counter + 1
Call disassemble
If PICbyte > 32767 Then PICbyte = 32767
C = PICbyte \ 2: msb = C \ 256: lsb = C - (msb * 256)
tempC$ = Right$("000" + Hex$(C), 4):

If (Counter Mod 8) = 0 Then
If hexic$ <> blank$ Then
 hexiAAAA$ = Right$("000" + Hex$(aaaa * 2), 4)
 HexN = HexN + nn + Val("&h" & Left$(hexiAAAA$, 2)) + Val("&h" & Right$(hexiAAAA$, 2))
 CheckSum = (-HexN) And 255
 hexiN$ = Right$("0" + Hex$(CheckSum), 2)
 hexiNN$ = Right$("0" + Hex$(nn), 2):
 hexic$ = ":" + hexiNN$ & hexiAAAA$ & RR$ & hexic$ & hexiN$
 If nn <> 0 Then Print #4, hexic$: List1.AddItem hexic$
 End If
 hexic$ = "": nn = 0: HexN = 0: aaaa = Counter
 Counter2 = Counter2 + 1
End If

nn = nn + 2: HexN = HexN + lsb + msb:
hexic$ = hexic$ + Right$(tempC$, 2) & Left$(tempC$, 2)
Next: Counter = Counter - 1
 
If (Counter Mod 8) > 0 Then
 HexN = HexN + nn: CheckSum = (-HexN) And 255
 hexiN$ = Right$("0" + Hex$(CheckSum), 2)
 hexiNN$ = Right$("0" + Hex$(nn), 2):
 hexiAAAA$ = Right$("000" + Hex$(aaaa * 2), 4)
 hexic$ = ":" & hexiNN$ & hexiAAAA$ & RR$ & hexic$ & hexiN$
 Print #4, hexic$: List1.AddItem hexic$
 
End If
Call switchoff

Call ReadConfig

H$ = Hex$(PICbyte)
embedconfig$ = Mid$(H$, 3, 2) & Left$(H$, 2)

hexic$ = ":02400E00" & embedconfig$: nn = 0: HexN = 0: '2
For C = 2 To Len(hexic$) Step 2
HexN = HexN + Val("&h" & Mid$(hexic$, C, 2))
Next
CheckSum = (-HexN) And 255
hexiN$ = Right$("0" + Hex$(CheckSum), 2)
hexic$ = hexic$ + hexiN$
Print #4, hexic$: List1.AddItem hexic$: Call switchoff

Call ReadMessageForHEXfile

hexic$ = ":00000001FF"
Print #4, hexic$: List1.AddItem hexic$: Close 4: Call switchoff
outputfile(12) = Counter


List1.AddItem ""
List1.AddItem tempA$

tempj$ = "": GoSub listit
tempj$ = "MPASM hex code example - :NN AAAA RR MMLL MMLL MMLL MMLL CC TT": GoSub listit
tempj$ = ":" & Chr$(9) & "  = record start character": GoSub listit
tempj$ = "NN" & Chr$(9) & "  = byte quantity in line as hex value": GoSub listit
tempj$ = "AAAA" & Chr$(9) & "  = address of first byte in hex": GoSub listit
tempj$ = "RR" & Chr$(9) & "  = record type in hex (normally 00 except last which is 01)": GoSub listit
tempj$ = Chr(9) & "    (Some hex files from other sources may have 04 as the record type - for reasons at present unknown)": GoSub listit
tempj$ = "MMLL" & Chr$(9) & "  = data bytes in order of MMLL in hex": GoSub listit
tempj$ = "NB MMLL = MSB/LSB for MPASM (but would be LSB/MSB for TASM HEX)": GoSub listit
tempj$ = "CC" & Chr$(9) & "  = check sum in hex": GoSub listit
tempj$ = "TT" & Chr$(9) & "  = line terminator (carriage return, line feed)": GoSub listit
tempj$ = "Checksum defined as:": GoSub listit
tempj$ = "sum" & Chr$(9) & "  = byte count + address hi + address lo + record type": GoSub listit
tempj$ = "                    + (sum of all data bytes)": GoSub listit
tempj$ = "checksum = (-sum) AND 255": GoSub listit
tempj$ = "": GoSub listit

List1.Visible = True
Quit.Visible = True
Quit.SetFocus
Label1.Visible = True
Label2.Visible = True

Exit Sub

listit:
List1.AddItem tempj$
Counter2 = Counter2 + 1
Return

showerror:
TK3ShowError.Show
Call TK3ShowError.waitresponse
Resume enderror
enderror:

End Sub

Public Sub HEXdisasm(): ' new routine June 04 ' HEX to MPASM disasm
On Error GoTo showerror
'List2.Clear
BSR$(0) = ",A": BSR$(1) = ",B"

AddressVal1 = 0
For A = 0 To 255: For B = 0 To 10
DC(A, B) = 0: Next: Next
CodeCount = 0

CF = 256: PCLATH = 0: Counter2 = 0

If PICsize > 1024 Then PicType = 1 Else PicType = 0

Quit.Visible = False
List1.Visible = False
List1.Clear
Label1.Visible = False
Label2.Visible = False
TK3disassembleMPASM.Cls
TK3disassembleMPASM.Show

ProgressBar1.Visible = True
ProgressBar1.Min = 1

Cls
Print Tab(3); "Disassembling " & NamedFile(PICpath) & " to " & outputfile(PICpath): '14

For B = 0 To 255: Reg$(B) = "REG" + Right$("0" + Hex$(B), 2): Next

File$ = "P" & Mid$(PICdevice, 4) & ".inc"
OpenFile = File$: Open File$ For Input As #1

If Left$(PICdevice, 6) = "PIC18F" Then
X = X
getit18F: Line Input #1, tempA$:
If EOF(1) Then
Close 1: GoTo OpenCodes
End If

If Left$(tempA$, 1) = ";" Then GoTo getit18F
For C = 1 To Len(tempA$)
If Mid$(tempA$, C, 3) = "EQU" Then
DA$(1) = RTrim$(Left$(tempA$, C - 1))
DA$(2) = LTrim$(Mid$(tempA$, C + 4))
B = Val("&h" & Mid$(DA$(2), 3, 4))
If B < &H1000 And B > &HEFF Then
'B = B And 255:
Reg$(B) = DA$(1)
End If
Exit For
End If
Next
GoTo getit18F
Close

Else

PrevB = -1: B = -1
getit:
Input #1, tempA$: If EOF(1) Then Close 1: GoTo OpenCodes
If Left$(tempA$, 1) = ";" Then GoTo getit
If Left$(tempA$, 2) = "W " Then GoTo getit
If Left$(tempA$, 2) = "F " Then GoTo getit

For C = 1 To Len(tempA$)
If Mid$(tempA$, C, 3) = "EQU" Then
DA$(1) = RTrim$(Left$(tempA$, C - 1))
DA$(2) = LTrim$(Mid$(tempA$, C + 4))
B = Val("&h" & Mid$(DA$(2), 3, 4))
If B > PrevB Then Reg$(B) = DA$(1)
Exit For
End If
Next
If B >= PrevB Then PrevB = B: GoTo getit
Close

End If

OpenCodes:
Print: Print: Print Tab(3); PICname & " registers"

' *************

'aj reversed logic 19Aug04
If Left$(PICdevice, 6) = "PIC18F" Then
OpenFile = "TK3asmcodes18F.TXT": B = 16
Else
OpenFile = "TK3asmcodes16F.TXT": B = 14
End If
'aj end 19Aug04

Open OpenFile For Input As #1: CodeCount = 0
OpenFile = ""

getcodes: If EOF(1) Then Close 1: GoTo sortcodes
Line Input #1, tempA$
QY = Val(Mid$(CODE$(B), 9, 2))
If QY < 40 Then CodeCount = CodeCount + 1: CODE$(CodeCount) = tempA$
GoTo getcodes

sortcodes:

For A = 1 To CodeCount: Bin$ = Mid$(CODE$(A), 12, B): '14):
L = Len(Bin$): flagit = 0
d = 0: Vx = 0: For C = L To 1 Step -1
tempA$ = Mid$(Bin$, C, 1)
E2 = Val(tempA$) * (2 ^ d)
Vx = Vx + E2:
If tempA$ = "0" Or tempA$ = "1" Or tempA$ = "x" Then
DC(A, 0) = DC(A, 0) + (2 ^ d): GoTo 100
End If

If tempA$ = "f" Then DC(A, 1) = DC(A, 1) + (2 ^ d): GoTo 100
If tempA$ = "d" Then DC(A, 2) = DC(A, 2) + (2 ^ d): GoTo 100
If tempA$ = "a" Then DC(A, 3) = DC(A, 3) + (2 ^ d): GoTo 100
If tempA$ = "b" Then DC(A, 4) = DC(A, 4) + (2 ^ d): GoTo 100
If tempA$ = "k" Then DC(A, 5) = DC(A, 5) + (2 ^ d): GoTo 100
If tempA$ = "n" Then DC(A, 6) = DC(A, 6) + (2 ^ d): GoTo 100
100: d = d + 1
Next

codevalue(A) = Vx:
Next

' *************

ErrorCount = 0
For C = 100 To PICsize + 100: ma(C) = 0: Next: A = 0
ma(100) = 1
ma(101) = 1
ma(102) = 1
ma(103) = 1
ma(104) = 1
ma(105) = 1
configbyte = 0: DataEeprom = 0

Open FileName For Input As #1: L = LOF(1)
Open "STORE1.TXT" For Output As #2
ProgressBar1.Max = L: Counter = 0: filetype$ = ""

getit400: If EOF(1) Then ProgressBar1.value = ProgressBar1.Max: GoTo end410
Input #1, tempA$: L = Len(tempA$) - 2

Counter = Counter + L
ProgressBar1.value = Counter
If Mid$(tempA$, 9, 1) = "4" Then
If Mid$(tempA$, 12, 2) = "00" Then GoTo getit400
ProgressBar1.value = ProgressBar1.Max: GoTo end410
End If

F = Val("&h" + Mid$(tempA$, 4, 4))
If F > A Then
  Print #2, ""

  If Hex$(F \ 2) = "2007" Then Print #2, "; ";
  Print #2, "ORG " & (F \ 2) & Chr(9) & Chr(9) & "; H'" & Hex$(F \ 2) & "'"
  If Hex$(F \ 2) = "2007" Then
configbyte = Val("&h" & Mid$(tempA$, 12, 2) & Mid$(tempA$, 10, 2))
tempB$ = Hex$(configbyte)
  A = F
  Print #2, "; Config = H'" & tempB$ & "'"
  GoTo getit400
  End If
  
    If Hex$(F \ 2) = "2100" Then
    DataEeprom = 1
    End If
    
  If F \ 2 > 8191 And F \ 2 < 8448 Then
    Print #2, "; This exceptionally high ORG address value (H";
    Print #2, Hex$(F \ 2) & ") may in fact represent a Config or Data ";
    Print #2, "Eeprom address. See TK3 Assembly Notes"
    End If
  Print #2, "": Print #2, ""
  A = F
End If

If Val("&h" & Mid$(tempA$, 8, 2)) > 1 Then filetype$ = Mid$(tempA$, 8, 2)

For DX = 10 To L - 2 Step 4
PIClsb$ = Mid$(tempA$, DX, 2)
PICmsb$ = Mid$(tempA$, DX + 2, 2)
msb = Val("&h" + PICmsb$): lsb = Val("&h" + PIClsb$)
PICbyte = Val("&h" & Mid$(tempA$, DX + 2, 2) & Mid$(tempA$, DX, 2))
If PICbyte < 0 Then PICbyte = PICbyte + 65536

If DataEeprom = 1 Then
DecodeK = PICbyte: code2$ = ""
jd = DecodeK: For jt = 7 To 0 Step -1: ja = 2 ^ jt: jw = jd / ja
If jw >= 1 Then jd = jd - ja: code2$ = code2$ & "1" Else code2$ = code2$ & "0"
Next:
tempB$ = "; " & Left$(Str$((A \ 2) - &H2100) & "    ", 4)
PICmsb$ = tempB$ & "  H'" & Right$("0" + Hex$(DecodeK), 2) & "'  B'" & code2$ & "'  "
If DecodeK > 31 And DecodeK < 255 Then PIClsb$ = Chr$(34) & Chr$(DecodeK) & Chr$(34) Else PIClsb$ = "ASCII control character"
PICdecode$ = DecodeK & Chr(9) & PICmsb$ & PIClsb$

Print #2, "DE      " & PICdecode$
GoTo DataBypass
End If

PICdecode$ = "UNFOUND"
For B = 1 To CodeCount
C = DC(B, 0) And PICbyte
If C = codevalue(B) Then
QY = Val(Mid$(CODE$(B), 9, 2))
If QY < 40 Then
PICdecode$ = LCase$(Left$(CODE$(B), 8))
If Left$(PICdevice, 6) = "PIC18F" Then
Call GetCommandCode18F: Exit For
Else
Call GetCommandCode16F: Exit For
End If
End If
End If

DataBypass:
Next

If PICdecode$ = "UNFOUND" Then
If PICbyte = 16383 Or PICbyte = 63 Then
PICdecode$ = "NOP   ; No Code = " & PICbyte
Else
PICdecode$ = "NOP   ; Unfound value = " & PICbyte
End If
End If

Counter2 = Counter2 + 1
If DataEeprom = 1 Then

GoTo DataBypass2
End If

Print #2, PICdecode$

DataBypass2:
A = A + 2: Next
GoTo getit400

end410:

Close
commandsize(14) = Counter2

Open "STORE1.TXT" For Input As #1

Open outputfile(PICpath) For Output As #2

'If Left$(PICdevice, 6) = "PIC18F" Then
' tempB$ = "; THIS PROCEDURE IS NOT YET COMPLETE FOR PIC18F DEVICES"
'Print #2, ""
'Print #2, tempB$
'Print #2, ""
'List1.AddItem "": List1.AddItem tempB$: List1.AddItem ""
'End If

tempB$ = "; Disassembly from " & inputfile(PICpath) & " on " & Date$ & " at " & Time$: '14
List1.AddItem tempB$: List1.AddItem ""
Print #2, tempB$: Print #2, ""

Print #2, "; " & PICname & " Registers selected"
List1.AddItem "; " & PICname & " Registers selected"
List1.AddItem ""
Print #2, ""

tempB$ = Chr(9) & "List P = " & PICdevice & ", R=DEC; "
List1.AddItem tempB$: List1.AddItem ""
Print #2, tempB$: Print #2, ""

If EmbeddedPicID$ <> "" Then
Print #2, "; PIC type embedded in PIC = " & EmbeddedPicID$
If PICdevice & " " <> Left$(EmbeddedPicID$, Len(PICdevice) + 1) Then
If Left$(EmbeddedPicID$, 3) = "PIC" Then
Print #2, ""
Print #2, "; Embedded PIC type does not match selected PIC type"
End If
End If
Print #2, ""
End If

If configbyte > 0 Then
tempB$ = Chr(9) & "__CONFIG H'" & Hex$(configbyte) & "'"
List1.AddItem tempB$: List1.AddItem ""
Print #2, tempB$: Print #2, ""
End If

tempB$ = PICdevice & ".INC"
If Left$(tempB$, 3) = "PIC" Then tempB$ = "P" & Mid$(PICdevice, 4) ' & ".inc"
List1.AddItem Chr(9) & "include " & tempB$: List1.AddItem ""
Print #2, Chr(9) & "include " & tempB$ & ".inc": Print #2, ""

For A = 0 To 4095
If RegFlag(A) > 0 And Left$(Reg$(A), 3) = "REG" Then
If A < 256 Then H$ = Right$("0" & Hex$(A), 2) Else H$ = Right$("000" & Hex$(A), 4)
Print #2, Reg$(A) & Chr(9) & "  EQU H'" & H$ & "'"
End If
Next

Print #2, "W:        EQU 0": Print #2, "F:        EQU 1"
Print #2, "C:        EQU 0": Print #2, "DC:       EQU 1"
Print #2, "Z:        EQU 2": Print #2, ""

A = 0
Print #2, Chr(9) & "  ORG 0": Print #2, ""
List1.AddItem Chr(9) & "   ORG 0"

getit600: If EOF(1) Then GoTo endit600
Line Input #1, tempA$:
If tempA$ = "Erased memory" Then
OrgVal = A: A = A + 1
GoTo getit600
End If

If Left$(RTrim$(tempA$), 3) = "ORG" Then
A = Val(Mid$(RTrim$(tempA$), 4)) - 3
End If

If A > 9150 Then tempC$ = LTrim$(Str$(A)): GoTo BypassLargeVal
If ma(A + 100) = 0 Then
   tempA$ = Chr$(9) & "  " & tempA$

 Else
If A < 10000 Then
tempC$ = Left$(LTrim$(Str$(A)) & "    ", 4)
Else
tempC$ = LTrim$(Str$(A))
End If

If Left$(tempA$, 2) = "DE" Then
A = A
End If

tempA$ = "JUMP" & tempC$ & "  " & tempA$

End If

BypassLargeVal:

If OrgVal > 0 Then
Print #2, ""
Print #2, Chr(9) & "  ORG " & OrgVal + 1: OrgVal = 0
Print #2, ""
End If

Print #2, tempA$
List1.AddItem tempA$
A = A + 1
GoTo getit600

endit600:
Print #2, "          END":

Close:
Call switchoff
Label2.Caption = Str$(Counter2) & " Lines"

OpenFile = FileName
Open FileName For Input As #1: L = LOF(1)
inputsize(PICpath) = L:
Close 1: OpenFile = ""
List1.Visible = True
Label1.Visible = True
Label2.Visible = True
Quit.Visible = True
Counter = Counter2

Call TK3MainProgram.showdefaults

If PICdevice & " " <> Left$(EmbeddedPicID$, Len(PICdevice) + 1) Then
If Left$(EmbeddedPicID$, 3) = "PIC" Then
tempB$ = "Warning Only - "
tempB$ = tempB$ & "Embedded PIC type " & EmbeddedPicID$
tempB$ = tempB$ & "does not match selected PIC type " & PICdevice
Label3.Caption = tempB$: Label3.Visible = True
End If
End If
EmbeddedPicID$ = ""
Exit Sub

showerror:
TK3ShowError.Show
Call TK3ShowError.waitresponse
Resume enderror
enderror:
Unload TK3disassembleMPASM
End Sub

Public Sub MPASMdisasm()
Call MPASMhexit
Call HEXdisasm
End Sub

Public Sub GetCommandCode16F()

Select Case QY

Case 1:
DecodeF = (PICbyte And DC(B, 1)) + Bank0: RegFlag(DecodeF) = 1
DecodeD = (PICbyte And DC(B, 2)) \ 128
If DecodeD = 0 Then Dest$ = "W" Else Dest$ = "F"
If Reg$(DecodeF) = "" Then Reg$(DecodeF) = "UNFOUND" & Chr(9) & Chr(9) & "; - check that you decoded for correct PIC type"
PICdecode$ = PICdecode$ & " " & Reg$(DecodeF) & "," & Dest$
'ADDWF  f,d  00 0111 dfff ffff *
'ANDWF  f,d  00 0101 dfff ffff *
'COMF   f,d  00 1001 dfff ffff *
'DECF   f,d  00 0011 dfff ffff *
'DECFSZ f,d  00 1011 dfff ffff *
'INCF   f,d  00 1010 dfff ffff *
'INCFSZ f,d  00 1111 dfff ffff *
'IORWF  f,d  00 0100 dfff ffff *
'MOVF   f,d  00 1000 dfff ffff *
'RLF    f,d  00 1101 dfff ffff *
'RRF    f,d  00 1100 dfff ffff *
'SUBWF  f,d  00 0010 dfff ffff *
'SWAPF  f,d  00 1110 dfff ffff *
'XORWF  f,d  00 0110 dfff ffff *

Case 2:
DecodeF = (PICbyte And DC(B, 1)) + Bank0: RegFlag(DecodeF) = 1
DecodeB = (PICbyte And DC(B, 4)) \ 128
If Reg$(DecodeF And 127) <> "STATUS" Then
PICdecode$ = PICdecode$ & " " & Reg$(DecodeF) & "," & LTrim$(Str$(DecodeB))
Else
tempC$ = DecodeB: DecodeF = DecodeF And 127
If DecodeB = 0 Then tempC$ = "C"
If DecodeB = 1 Then tempC$ = "DC"
If DecodeB = 2 Then tempC$ = "Z"
If DecodeB = 5 Then
If Left$(PICdecode$, 4) = "bsf " Then Bank0 = 128
If Left$(PICdecode$, 4) = "bcf " Then Bank0 = 0
End If
PICdecode$ = PICdecode$ & " " & Reg$(DecodeF) & "," & tempC$: ' & ";  " & PICbyte
End If
'BCF    f,b  01 00bb bfff ffff *
'BSF    f,b  01 01bb bfff ffff *
'BTFSC  f,b  01 10bb bfff ffff *
'BTFSS  f,b  01 11bb bfff ffff *

Case 3:
DecodeK = PICbyte And DC(B, 5): code2$ = ""
jd = DecodeK: For jt = 7 To 0 Step -1: ja = 2 ^ jt: jw = jd / ja
If jw >= 1 Then jd = jd - ja: code2$ = code2$ & "1" Else code2$ = code2$ & "0"
Next: PICmsb$ = ";  H'" & Right$("0" + Hex$(DecodeK), 2) & "'  B'" & code2$ & "'  "
If DecodeK > 31 Then PIClsb$ = Chr$(34) & Chr$(DecodeK) & Chr$(34) Else PIClsb$ = "ASCII control character"
PICdecode$ = PICdecode$ & " " & DecodeK & Chr(9) & Chr(9) & PICmsb$ & PIClsb$

'ADDLW  k    11 1110 kkkk kkkk
'ANDLW  k    11 1001 kkkk kkkk
'IORLW  k    11 1000 kkkk kkkk
'MOVLW  k    11 00xx kkkk kkkk
'RETLW  k    11 01xx kkkk kkkk
'SUBLW  k    11 110x kkkk kkkk
'XORLW  k    11 1010 kkkk kkkk

Case 4:
DecodeF = PICbyte And DC(B, 1) + Bank0: RegFlag(DecodeF) = 1
If Reg$(DecodeF And 127) = "STATUS" Then
DecodeF = DecodeF And 127
If Left$(PICdecode$, 5) = "clrf " Then Bank0 = 0
End If
PICdecode$ = PICdecode$ & " " & Reg$(DecodeF)
'CLRF   f    00 0001 1fff ffff
'MOVWF  f    00 0000 1fff ffff

Case 5: ' no change
'CLRW   -    00 0001 0000 0011
'CLRWDT -    00 0000 0110 0100
'NOP    -    00 0000 0xx0 0000
'RETFIE -    00 0000 0000 1001
'RETURN -    00 0000 0000 1000
'SLEEP  -    00 0000 0110 0011

Case 6:
DecodeK = PICbyte And DC(B, 5)
PICdecode$ = PICdecode$ & " JUMP" & LTrim$(Str$(DecodeK))
ma(DecodeK + 100) = 1
'CALL   k    10 0kkk kkkk kkkk
'GOTO   k    10 1kkk kkkk kkkk

End Select

End Sub

Public Sub ReadMessage(): ' for disassemble to ASM file
On Error GoTo showerror

ProgressBar1.value = 1
ProgressBar1.Min = 1
ProgressBar1.Max = eeprom%

Call switchon
For Counter = 0 To eeprom% - 1: GoSub ReadDecode
ProgressBar1.value = Counter + 1
Print #2, tempA$: Next
Call switchoff:
Exit Sub

ReadDecode: 'read EEPROM data
SendVal = 5: BitVal = 6: Call sendit: '$000101 "read EEPROM data" command
PICbyte = 0
For loopb = 15 To 0 Step -1: PICbyte = PICbyte \ 2: Call getbit: Next

'aj changed 19Aug04
If Not PnM_LowPinCount() Then
SendVal = 8: BitVal = 6: Call sendit: '$001000 "prog accept" command
End If
'aj end 19Aug04

SendVal = 6: BitVal = 6: Call sendit: '$000110 "step address"

PICbyte = (PICbyte And 511) \ 2: code2$ = ""
jd = PICbyte: For jt = 7 To 0 Step -1: ja = 2 ^ jt: jw = jd / ja
If jw >= 1 Then jd = jd - ja: code2$ = code2$ & "1" Else code2$ = code2$ & "0"
Next:
PICmsb$ = Chr(9) & "DE  H'" & Right$("0" + Hex$(PICbyte), 2) & "'" & Chr(9) & "; B'" & code2$ & "'"
PIClsb$ = Right$("    " & PICbyte, 4) & " "
If PICbyte > 13 Then
   PIClsb$ = PIClsb$ & " " & Chr$(34) & Chr$(PICbyte) & Chr$(34)
   Else
   PIClsb$ = PIClsb$ & "    "
   End If
tempA$ = PICmsb$ & PIClsb$ & "      " & Counter: Call delay10
List1.AddItem tempA$
Return

showerror:
TK3ShowError.Show
Call TK3ShowError.waitresponse
Resume enderror
enderror:
Call Quit_Click
End Sub

Public Sub ReadConfig()
Call switchon
Dummy = &H1111:    ' dummy config val - seems like any val WILL do
SendVal = 0: BitVal = 6: Call sendit: '$000000 "config data" command
SendVal = Dummy * 2: BitVal = 16: Call sendit: 'data for load config (never actually programmed though)

For LoopA = 0 To 8
SendVal = 4: BitVal = 6: Call sendit: '$000100 "read program data" command

PICbyte = 0: For B = 1 To 16: PICbyte = PICbyte \ 2
Out Port1, (16 Or 2): ' 12V on, clk high
Call delay1: E = Inp(Port2):  ' get bit - while clock is high
Call delay1: Out Port1, 16: ' 12V on, clk low
E = E And 64: If E <> 0 Then PICbyte = PICbyte Or 32768
Next

PICbyte = PICbyte \ 2: PICbyte = PICbyte And &H3FFF

If LoopA = 6 Then
tempA$ = "ID " & PICbyte \ 32 & " v" & (PICbyte And 31)
tempB$ = ""
Select Case PICbyte \ 32
Case 43: tempB$ = "PIC16F84A "
Case 61: tempB$ = "PIC16F627 "
Case 57: tempB$ = "PIC16F628 "
Case 77: tempB$ = "PIC16F877 "
Case 79: tempB$ = "PIC16F876 "
Case 112: tempB$ = "PIC16F876A "
Case 113: tempB$ = "PIC16F877A "
Case 511: tempB$ = "PIC16F84 ? ": tempA$ = "ID " & Hex$(PICbyte)
End Select

If tempB$ = "" Then tempB$ = tempA$ Else tempA$ = tempB$ & tempA$
TK3MainProgram.PicID(PICpath).Caption = tempB$
TK3MainProgram.PicID(PICpath).ToolTipText = tempA$ & "  "
EmbeddedPicID$ = tempA$
End If

If LoopA = 7 Then
F = PICbyte
F = F
End If
SendVal = 6: BitVal = 6: Call sendit: '$000110 "step address"
DA$(LoopA) = "H'" & Right$("000" & Hex$(PICbyte), 4) & "'"
Next
PICbyte = F
Call switchoff
End Sub

Public Sub ReadMessageForHEXfile()
On Error GoTo showerror

ProgressBar1.value = 1
ProgressBar1.Min = 1
ProgressBar1.Max = eeprom%
aaaa = &H2100
hexif$ = "00": hexic$ = "": hexiD$ = "": hexD = 0
nn = 0: RR$ = "00"
Counter2 = 0

Call switchon
For Counter = 0 To eeprom% - 1: GoSub ReadDecode
ProgressBar1.value = Counter + 1

If PICbyte > 32767 Then PICbyte = 32767
C = PICbyte \ 2: msb = C \ 256: lsb = C - (msb * 256)
tempC$ = Right$("000" + Hex$(C), 4):

If (Counter Mod 8) = 0 Then
 hexiAAAA$ = Right$("000" + Hex$(aaaa * 2), 4)
 HexN = HexN + nn + Val("&h" & Left$(hexiAAAA$, 2)) + Val("&h" & Right$(hexiAAAA$, 2))
 CheckSum = (-HexN) And 255
 hexiN$ = Right$("0" + Hex$(CheckSum), 2)
 hexiNN$ = Right$("0" + Hex$(nn), 2):
 hexic$ = ":" + hexiNN$ & hexiAAAA$ & RR$ & hexic$ & hexiN$
 If nn <> 0 Then Print #4, hexic$: List1.AddItem hexic$
 hexic$ = "": nn = 0: HexN = 0: aaaa = Counter + &H2100
End If

nn = nn + 2: HexN = HexN + lsb + msb:
hexic$ = hexic$ + Right$(tempC$, 2) & Left$(tempC$, 2)
Next: Counter = Counter - 1
 
If (Counter Mod 8) > 0 Then
 HexN = HexN + nn: CheckSum = (-HexN) And 255
 hexiN$ = Right$("0" + Hex$(CheckSum), 2)
 hexiNN$ = Right$("0" + Hex$(nn), 2):
 hexiAAAA$ = Right$("000" + Hex$(aaaa * 2), 4)
 hexic$ = ":" & hexiNN$ & hexiAAAA$ & RR$ & hexic$ & hexiN$
 Print #4, hexic$: List1.AddItem hexic$
 
End If

Call switchoff:
Exit Sub

ReadDecode: 'read EEPROM data
SendVal = 5: BitVal = 6: Call sendit: '$000101 "read EEPROM data" command
PICbyte = 0
For loopb = 15 To 0 Step -1: PICbyte = PICbyte \ 2: Call getbit: Next
'aj changed 19Aug04
If Not PnM_LowPinCount() Then
SendVal = 8: BitVal = 6: Call sendit: '$001000 "prog accept" command
End If
'aj end 19Aug04

SendVal = 6: BitVal = 6: Call sendit: '$000110 "step address"
PICbyte = (PICbyte And 511) \ 2
Return

showerror:
TK3ShowError.Show
Call TK3ShowError.waitresponse
Resume enderror
enderror:
Call Quit_Click

End Sub

Public Sub MPASMhexit18F() ' PIC to HEX disasm for 18F devices

On Error GoTo showerror

USB18F = &HE00: MSB18F = &HE00: LSB18F = &HE00
cmdAbort.Visible = True
If PICpath <> 10 And PICpath <> 4 Then PICpath = 12

FileName = "PICDECODE.HEX"
inputfile(12) = "PICDECODE.HEX"
NamedFile(12) = "PICDECODE.HEX"
Label1.Caption = "QUICKVIEW LISTING"
Quit.Visible = False
List1.Visible = False
List1.Clear
Label1.Visible = False
Label2.Visible = False
AbortPressed = False    ' ** Malc **

ProgressBar1.Visible = True
ProgressBar1.Min = 1
ProgressBar1.Max = PICsize + 1
Cls
Print Tab(3); "Downloading " & PICdevice & " to "; FileName & " Commands = " & PICsize

If VerifyInProgress > 0 Then
TK3ProgramPIC.ProgressBar1.Visible = True
TK3ProgramPIC.ProgressBar1.Min = 1
TK3ProgramPIC.ProgressBar1.Max = PICsize + 1
End If

OpenFile = FileName
Open FileName For Output As #4
OpenFile = ""

hexif$ = "00": hexic$ = "": hexiD$ = "": hexD = 0
nn = 0: aaaa = 0: RR$ = "00"
Counter2 = 0

Call InitialisePICread18F

Print #4, ":020000040000FA"
List1.AddItem ":020000040000FA obligatory start"

Counter = 0

PICreadLoop:
ProgressBar1.value = Counter + 1

DoEvents                            '  ** Malc **
If (AbortPressed) Then
Close #4
'List1.Visible = True
Quit.Visible = True
Quit.SetFocus
Label1.Caption = "DOWNLOAD ABORTED"
Label1.Visible = True
Label2.Visible = True
cmdAbort.Visible = False

Exit Sub
End If                              ' ** Malc **


If VerifyInProgress > 0 Then
TK3ProgramPIC.ProgressBar1.value = Counter + 1
End If

Call PicLineRead18F

If tempC$ <> "FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF" Then
hexiAAAA$ = Right$("000" + Hex$(Counter * 2), 4)
HexN = HexN + Val("&h" & Left$(hexiAAAA$, 2)) + Val("&h" & Right$(hexiAAAA$, 2))
HexN = HexN + 16 ' 16 is byte count in decoded line
CheckSum = (-HexN) And 255
hexiN$ = Right$("0" + Hex$(CheckSum), 2)
hexiNN$ = Right$("0" + Hex$(16), 2): ' 16 is byte count in decoded line
hexic$ = ":10" & hexiAAAA$ & RR$
List1.AddItem hexic$ & tempC$ & hexiN$
Print #4, hexic$ & tempC$ & hexiN$
End If

Counter = Counter + 8

If Counter < PICsize Then GoTo PICreadLoop
X = X

GetUserIDvalues18F:
Print #4, ":020000040020DA"
List1.AddItem ":020000040020DA  ID obligatory"

USB18F = &HE20: MSB18F = &HE00: LSB18F = &HE00

Call InitialisePICread18F
Call PicLineRead18F
hexic$ = ":08000000" & tempC$: nn = 0: HexN = 0: '2
For C = 2 To Len(hexic$) Step 2
HexN = HexN + Val("&h" & Mid$(hexic$, C, 2))
Next
CheckSum = (-HexN) And 255
hexiN$ = Right$("0" + Hex$(CheckSum), 2)
hexic$ = hexic$ + hexiN$
Print #4, hexic$: List1.AddItem hexic$

GetConfigvalues18F:
Print #4, ":020000040030CA"
List1.AddItem ":020000040030CA obligatory config"

USB18F = &HE30: MSB18F = &HE00: LSB18F = &HE00
Call InitialisePICread18F
Call PicLineRead18F
hexic$ = ":0E000000" & Left$(tempC$, 28)

nn = 0: HexN = 0: '2
For C = 2 To Len(hexic$) Step 2
HexN = HexN + Val("&h" & Mid$(hexic$, C, 2))
Next
CheckSum = (-HexN) And 255
hexiN$ = Right$("0" + Hex$(CheckSum), 2)
hexic$ = hexic$ + hexiN$
Print #4, hexic$: List1.AddItem hexic$

GetDataEEprom:
Print #4, ":0200000400F00A"
List1.AddItem ":0200000400F00A obligatory eeprom"

LSB18F = &HE00

' 1 ************  Access to Data EEprom COMMANDS *******
'            Modified from DS39576 page 22

SendVal = 0: BitVal = 4: GoSub SendIt18F
SendVal = &H9EA6: BitVal = 16: GoSub SendIt18F '

SendVal = 0: BitVal = 4: GoSub SendIt18F
SendVal = &H9CA6: BitVal = 16: GoSub SendIt18F

For Counter = 0 To eeprom% - 1 Step 8
'hexic$ = ""
hexic$ = ":10" & Right$("0000" & Hex$(Counter * 2), 4)


For counter1 = 1 To 8
GoSub ReadDecode18F
hexic$ = hexic$ & Right$("000" & Hex$(PICbyte), 4)
LSB18F = LSB18F + 1
Next

hexic$ = hexic$ & "00"

nn = 0: HexN = 0: '2
For C = 2 To Len(hexic$) Step 2
HexN = HexN + Val("&h" & Mid$(hexic$, C, 2))
Next
CheckSum = (-HexN) And 255
hexiN$ = Right$("0" + Hex$(CheckSum), 2)
hexic$ = hexic$ + hexiN$
Print #4, hexic$: List1.AddItem hexic$

Next

GetDeviceID:
USB18F = &HE3F: MSB18F = &HEFF: LSB18F = &HEFE
Call InitialisePICread18F
Call PicLineRead18F
A = Val("&h" & Mid$(tempC$, 3, 2) & Left$(tempC$, 2))
tempA$ = "ID " & A \ 32 & " v" & (A And 31)
tempB$ = ""
Select Case A \ 32
Case 32: tempB$ = "PIC18F252 "
Case 33: tempB$ = "PIC18F452 "
Case 36: tempB$ = "PIC18F242 "
Case 37: tempB$ = "PIC18F442 "
Case 64: tempB$ = "PIC18F248 "
Case 65: tempB$ = "PIC18F448 "
Case 66: tempB$ = "PIC18F258 "
Case 67: tempB$ = "PIC18F458 "
End Select

If tempB$ = "" Then tempB$ = tempA$ Else tempA$ = tempB$ & tempA$

TK3MainProgram.PicID(PICpath).Caption = tempB$
TK3MainProgram.PicID(PICpath).ToolTipText = tempA$ & "  "
EmbeddedPicID$ = tempA$

BypassConfigEtc:

hexic$ = ":00000001FF"
Print #4, hexic$: List1.AddItem hexic$: Close 4
outputfile(12) = Counter

List1.AddItem ""
List1.AddItem tempA$

If VerifyInProgress > 0 Then VerifyInProgress = 0: Exit Sub

tempj$ = "": GoSub listit
tempj$ = "MPASM hex code example - :NN AAAA RR MMLL MMLL MMLL MMLL CC TT": GoSub listit
tempj$ = ":" & Chr$(9) & "  = record start character": GoSub listit
tempj$ = "NN" & Chr$(9) & "  = byte quantity in line as hex value": GoSub listit
tempj$ = "AAAA" & Chr$(9) & "  = address of first byte in hex": GoSub listit
tempj$ = "RR" & Chr$(9) & "  = record type in hex (normally 00 except last which is 01)": GoSub listit
tempj$ = Chr(9) & "    (Some hex files from other sources may have 04 as the record type - for reasons at present unknown)": GoSub listit
tempj$ = "MMLL" & Chr$(9) & "  = data bytes in order of MMLL in hex": GoSub listit
tempj$ = "NB MMLL = MSB/LSB for MPASM (but would be LSB/MSB for TASM HEX)": GoSub listit
tempj$ = "CC" & Chr$(9) & "  = check sum in hex": GoSub listit
tempj$ = "TT" & Chr$(9) & "  = line terminator (carriage return, line feed)": GoSub listit
tempj$ = "Checksum defined as:": GoSub listit
tempj$ = "sum" & Chr$(9) & "  = byte count + address hi + address lo + record type": GoSub listit
tempj$ = "                    + (sum of all data bytes)": GoSub listit
tempj$ = "checksum = (-sum) AND 255": GoSub listit
tempj$ = "": GoSub listit

List1.Visible = True
Quit.Visible = True
Quit.SetFocus
Label1.Visible = True
Label2.Visible = True
cmdAbort.Visible = False
ProgressBar1.value = ProgressBar1.Max

Exit Sub

listit:
List1.AddItem tempj$
Counter2 = Counter2 + 1
Return

ReadDecode18F:

' ************ send address commands ******

SendVal = 0: BitVal = 4: GoSub SendIt18F
SendVal = LSB18F: BitVal = 16: GoSub SendIt18F

SendVal = 0: BitVal = 4: GoSub SendIt18F
SendVal = &H6EA9: BitVal = 16: GoSub SendIt18F

' ************* initiate read *********

SendVal = 0: BitVal = 4: GoSub SendIt18F
SendVal = &H80A6: BitVal = 16: GoSub SendIt18F

' ************* read data *********

SendVal = 0: BitVal = 4: GoSub SendIt18F
SendVal = &H50A8: BitVal = 16: GoSub SendIt18F

SendVal = 0: BitVal = 4: GoSub SendIt18F
SendVal = &H6EF5: BitVal = 16: GoSub SendIt18F

SendVal = 2: BitVal = 4: GoSub SendIt18F

PICbyte = 0
For B = 15 To 0 Step -1: PICbyte = PICbyte \ 2

GetBit18F:
Out Port1, (16 Or 2): ' 12V on, clk high
Out Port1, 16: ' 12V on, clk low
E = Inp(Port2) And 64:  ' get bit
If E <> 0 Then PICbyte = PICbyte Or 128
Next
Return

SendIt18F:
SendVal = SendVal And 65535
For C = BitVal To 1 Step -1
outval = SendVal And 1 Or 16
Out Port1, outval
Out Port1, (outval Or 2): 'val plus clock high
Out Port1, outval: 'val plus clock low
SendVal = SendVal \ 2: Next C
Return


showerror:
TK3ShowError.Show
Call TK3ShowError.waitresponse
Resume enderror
enderror:

End Sub

Private Sub GetBit18F() ' for 18F devices
Out Port1, (16 Or 2): ' 12V on, clk high
'Call delay1:   ' deleted 17MAR05
Out Port1, 16: ' 12V on, clk low
' Call delay1:   ' deleted 17MAR05
E = Inp(Port2):  ' get bit
E = E And 64: If E <> 0 Then PICbyte = PICbyte Or 128
End Sub

Public Sub SendIt18F() ' for 18F devices
For C = BitVal To 1 Step -1
outval = SendVal And 1 Or 16: 'val plus clock high
Out Port1, (outval Or 2)
't = Timer: 'intentional delay  ' deleted 17MAR05
Out Port1, outval: 'val plus clock low
SendVal = SendVal \ 2: Next C

' 16 = Vpp da4
' 2 clock  da1
' 1 data   da0

End Sub

Public Sub InitialisePICread18F()

SendVal = 0: BitVal = 4: Call SendIt18F
SendVal = USB18F: BitVal = 16: Call SendIt18F

SendVal = 0: BitVal = 4: Call SendIt18F
SendVal = &H6EF8: BitVal = 16: Call SendIt18F

SendVal = 0: BitVal = 4: Call SendIt18F
SendVal = MSB18F: BitVal = 16: Call SendIt18F

SendVal = 0: BitVal = 4: Call SendIt18F
SendVal = &H6EF7: BitVal = 16: Call SendIt18F

SendVal = 0: BitVal = 4: Call SendIt18F
SendVal = LSB18F: BitVal = 16: Call SendIt18F

SendVal = 0: BitVal = 4: Call SendIt18F
SendVal = &H6EF6: BitVal = 16: Call SendIt18F

End Sub

Public Sub PicLineRead18F()

tempC$ = "": HexN = 0

For John2 = 1 To 8
SendVal = 9: BitVal = 4: Call SendIt18F
SendVal = 0: BitVal = 8: Call SendIt18F

PICbyte = 0
For B = 7 To 0 Step -1: PICbyte = PICbyte \ 2
Call GetBit18F: Next

k = PICbyte
HexN = HexN + PICbyte

SendVal = 9: BitVal = 4: Call SendIt18F
SendVal = 0: BitVal = 8: Call SendIt18F

PICbyte = 0
For B = 7 To 0 Step -1: PICbyte = PICbyte \ 2
Call GetBit18F: Next

k = k * 256 + PICbyte
HexN = HexN + PICbyte

tempC$ = tempC$ & Right$("000" & Hex$(k), 4) ' & "   "

Next

End Sub

Public Sub GetCommandCode18F():

On Error GoTo showerror

Select Case QY

' DA$(1), DA$(2),  DA$(3),  DA$(4),  DA$(5)
' label,  command, k/f,     d/b,     a

'If tempA$ = "f" Then DC(A, 1) = DC(A, 1) + (2 ^ d): GoTo 100
'If tempA$ = "d" Then DC(A, 2) = DC(A, 2) + (2 ^ d): GoTo 100
'If tempA$ = "a" Then DC(A, 3) = DC(A, 3) + (2 ^ d): GoTo 100
'If tempA$ = "b" Then DC(A, 4) = DC(A, 4) + (2 ^ d): GoTo 100
'If tempA$ = "k" Then DC(A, 5) = DC(A, 5) + (2 ^ d): GoTo 100
'If tempA$ = "n" Then DC(A, 6) = DC(A, 6) + (2 ^ d): GoTo 100

Case 1:
DecodeA = (PICbyte And DC(B, 3)) \ 256
DecodeF = PICbyte And DC(B, 1)
DecodeD = (PICbyte And DC(B, 2)) \ 512
If DecodeD = 0 Then Dest$ = "W" Else Dest$ = "F"
tempC$ = Reg$(DecodeF): RegFlag(DecodeF) = 1
If Reg$(DecodeF) = "" Then
tempC$ = "(UNFOUND) " & DecodeF: Unfound = 1
End If
PICdecode$ = PICdecode$ & Chr(9) & tempC$ & "," & Dest$ & BSR$(DecodeA)

'ADDWF    1:001001daffffffff ' f,d,a ' 0010 01da ffff ffff
'ADDWFC   1:001000daffffffff ' f,d,a ' 0010 00da ffff ffff
'ANDWF    1:000101daffffffff ' f,d,a ' 0001 01da ffff ffff
'COMF     1:000111daffffffff ' f,d,a ' 0001 11da ffff ffff
'DECF     1:000001daffffffff ' f,d,a ' 0000 01da ffff ffff
'DECFSZ   1:001011daffffffff ' f,d,a ' 0010 11da ffff ffff
'DCFSNZ   1:010011daffffffff ' f,d,a ' 0100 11da ffff ffff
'INCF     1:001010daffffffff ' f,d,a ' 0010 10da ffff ffff
'INCFSZ   1:001111daffffffff ' f,d,a ' 0011 11da ffff ffff
'INFSNZ   1:010010daffffffff ' f,d,a ' 0100 10da ffff ffff
'IORWF    1:000100daffffffff ' f,d,a ' 0001 00da ffff ffff
'MOVF     1:010100daffffffff ' f,d,a ' 0101 00da ffff ffff
'RLCF     1:001101daffffffff ' f,d,a ' 0011 01da ffff ffff
'RLNCF    1:010001daffffffff ' f,d,a ' 0100 01da ffff ffff
'RRCF     1:001100daffffffff ' f,d,a ' 0011 00da ffff ffff
'RRNCF    1:010000daffffffff ' f,d,a ' 0100 00da ffff ffff
'SUBFWB   1:010101daffffffff ' f,d,a ' 0101 01da ffff ffff
'SUBWF    1:010111daffffffff ' f,d,a ' 0101 11da ffff ffff
'SUBWFB   1:010110daffffffff ' f,d,a ' 0101 10da ffff ffff
'SWAPF    1:001110daffffffff ' f,d,a ' 0011 10da ffff ffff
'XORWF    1:000110daffffffff ' f,d,a ' 0001 10da ffff ffff

Case 2:
DecodeA = (PICbyte And DC(B, 3)) \ 256
DecodeF = PICbyte And DC(B, 1)
DecodeB = (PICbyte And DC(B, 4)) \ 512
Dest$ = DecodeB
If Reg$(DecodeF) = "STATUS" Then
If DecodeB = 0 Then Dest$ = "C"
If DecodeB = 1 Then Dest$ = "DC"
If DecodeB = 2 Then Dest$ = "Z"
End If

If DecodeF <> 3 Then
tempC$ = Reg$(DecodeF): RegFlag(DecodeF) = 1
If Reg$(DecodeF) = "" Then
tempC$ = "(UNFOUND) " & DecodeF: Unfound = 1
End If

PICdecode$ = PICdecode$ & Chr(9) & tempC$ & "," & Dest$ & BSR$(DecodeA)
Else
tempC$ = Reg$(DecodeF): RegFlag(DecodeF) = 1
If Reg$(DecodeF) = "" Then
tempC$ = "(UNFOUND) " & DecodeF: Unfound = 1
End If

Dest$ = DecodeB
If Reg$(DecodeF) = "STATUS" Then
If DecodeB = 0 Then Dest$ = "C"
If DecodeB = 1 Then Dest$ = "DC"
If DecodeB = 2 Then Dest$ = "Z"
End If
PICdecode$ = PICdecode$ & Chr(9) & tempC$ & "," & Dest$ & BSR$(DecodeA)
End If
'BCF      2:1001bbbaffffffff ' f,b,a ' 1001 bbba ffff ffff
'BSF      2:1000bbbaffffffff ' f,b,a ' 1000 bbba ffff ffff
'BTFSC    2:1011bbbaffffffff ' f,b,a ' 1011 bbba ffff ffff
'BTFSS    2:1010bbbaffffffff ' f,b,a ' 1010 bbba ffff ffff
'BTG      2:0111bbbaffffffff ' f,b,a ' 0111 bbba ffff ffff

Case 3:
DecodeK = PICbyte And DC(B, 5)
PICmsb$ = "H'" & Right$("0" + Hex$(DecodeK), 2) & "'"
PICdecode$ = PICdecode$ & Chr(9) & PICmsb$
X = X
'ADDLW    3:00001111kkkkkkkk ' k     ' 0000 1111 kkkk kkkk
'ANDLW    3:00001011kkkkkkkk ' k     ' 0000 1011 kkkk kkkk
'IORLW    3:00001001kkkkkkkk ' k     ' 0000 1001 kkkk kkkk
'MOVLB    3:00000001kkkkkkkk ' k     ' 0000 0001 kkkk kkkk
'MOVLW    3:00001110kkkkkkkk ' k     ' 0000 1110 kkkk kkkk
'MULLW    3:00001101kkkkkkkk ' k     ' 0000 1101 kkkk kkkk
'SUBLW    3:00001000kkkkkkkk ' k     ' 0000 1000 kkkk kkkk
'XORLW    3:00001010kkkkkkkk ' k     ' 0000 1010 kkkk kkkk

Case 4:
DecodeN = PICbyte And DC(B, 6)
PICmsb$ = "H'" & Right$("0" + Hex$(DecodeN), 2) & "'"
PICdecode$ = PICdecode$ & Chr(9) & PICmsb$
'BC       4:11100010nnnnnnnn ' n     ' 1110 0010 nnnn nnnn
'BN       4:11100110nnnnnnnn ' n     ' 1110 0110 nnnn nnnn
'BNC      4:11100011nnnnnnnn ' n     ' 1110 0011 nnnn nnnn
'BNN      4:11100111nnnnnnnn ' n     ' 1110 0111 nnnn nnnn
'BNOV     4:11100101nnnnnnnn ' n     ' 1110 0101 nnnn nnnn
'BNZ      4:11100001nnnnnnnn ' n     ' 1110 0001 nnnn nnnn
'BOV      4:11100100nnnnnnnn ' n     ' 1110 0100 nnnn nnnn
'BZ       4:11100000nnnnnnnn ' n     ' 1110 0000 nnnn nnnn

Case 5:
DecodeA = (PICbyte And DC(B, 3)) \ 256
DecodeF = PICbyte And DC(B, 1)
tempC$ = Reg$(DecodeF): RegFlag(DecodeF) = 1
If Reg$(DecodeF) = "" Then tempC$ = "(UNFOUND) " & DecodeF: Unfound = 1
PICdecode$ = PICdecode$ & Chr(9) & tempC$ & BSR$(DecodeA)
'CLRF     5:0110101affffffff ' f,a   ' 0110 101a ffff ffff
'CPFSEQ   5:0110001affffffff ' f,a   ' 0110 001a ffff ffff
'CPFSGT   5:0110010affffffff ' f,a   ' 0110 010a ffff ffff
'CPFSLT   5:0110000affffffff ' f,a   ' 0110 000a ffff ffff
'MOVWF    5:0110111affffffff ' f,a   ' 0110 111a ffff ffff
'MULWF    5:0000001affffffff ' f,a   ' 0000 001a ffff ffff
'NEGF     5:0110110affffffff ' f,a   ' 0110 110a ffff ffff
'SETF     5:0110100affffffff ' f,a   ' 0110 100a ffff ffff
'TSTFSZ   5:0110011affffffff ' f,a   ' 0110 011a ffff ffff

Case 6: ' no change
'CLRWDT   6:0000000000000100 ' -     ' 0000 0000 0000 0100
'DAW      6:0000000000000111 ' -     ' 0000 0000 0000 0111
'NOP      6:0000000000000000 ' -     ' 0000 0000 0000 0000 ' or 1111 xxxx xxxx xxxx
'POP      6:0000000000000110 ' -     ' 0000 0000 0000 0110
'PUSH     6:0000000000000101 ' -     ' 0000 0000 0000 0101
'RESET    6:0000000011111111 ' -     ' 0000 0000 1111 1111
'SLEEP    6:0000000000000011 ' -     ' 0000 0000 0000 0011

Case 7:
'RETFIE   7:000000000001000s ' s     ' 0000 0000 0001 000s
'RETURN   7:000000000001001s ' s     ' 0000 0000 0001 001s

Case 8:
DecodeK = PICbyte And DC(B, 5)
PICmsb$ = "H'" & Right$("0" + Hex$(DecodeK), 2) & "'"
PICdecode$ = PICdecode$ & Chr(9) & PICmsb$
'RETLW    8:00001100kkkkkkkk ' k     ' 0000 1100 kkkk kkkk

Case 9
'DecodeN = PICbyte And DC(B, 6)
Select Case (PICbyte And 15)
Case 8: PICdecode$ = "tblrd*"
Case 9: PICdecode$ = "tblrd*+"
Case 10: PICdecode$ = "tblrd*-"
Case 11: PICdecode$ = "tblrd+*"
Case 12: PICdecode$ = "tblwt*"
Case 13: PICdecode$ = "tblwt*+"
Case 14: PICdecode$ = "tblwt*-"
Case 15: PICdecode$ = "tblwt+*"
End Select

'PICmsb$ = "H'" & Right$("0" + Hex$(DecodeN), 2) & "'"
'PICdecode$ = PICdecode$ & Chr(9) & PICmsb$

'TBLRD    9:00000000000010nn ' -     ' 0000 0000 0000 10nn
'TBLWT    9:00000000000011nn ' -     ' 0000 0000 0000 11nn

Case 10:
DecodeA = (PICbyte And DC(B, 3)) \ 256
DecodeK = PICbyte And DC(B, 5)
AddressCode$ = PICdecode$
tempC$ = "address " & DecodeK & " + (2nd byte * 256)"
PICdecode$ = Chr(9) & Chr(9) & Chr(9) & "  ; " & PICdecode$
PICdecode$ = PICdecode$ & tempC$ & BSR$(DecodeA)
ma(DecodeK + 100) = 1
'List2.AddItem DecodeK + 100
AddressVal1 = DecodeK '+ 100
'CALL    10:1110110akkkkkkkk ' n,s   ' 1110 110a k7kkk kkkk0 ' 2nd  1111 k19kkk kkkk  kkkk8

Case 11:
DecodeA = (PICbyte And DC(B, 3)) \ 256
DecodeK = PICbyte And DC(B, 5)
tempC$ = "address " & DecodeK & " + (2nd byte * 256)"
AddressCode$ = PICdecode$
PICdecode$ = Chr(9) & Chr(9) & Chr(9) & "  ; " & PICdecode$
PICdecode$ = PICdecode$ & tempC$ & BSR$(DecodeA)
ma(DecodeK + 100) = 1:
'List2.AddItem DecodeK + 100
AddressVal1 = DecodeK
'GOTO    11:11101111kkkkkkkk ' n     ' 1110 1111 k7kkk kkkk0 ' 2nd  1111 k19kkk kkkk kkkk8

Case 12:
DecodeF = (PICbyte And DC(B, 1)) \ 16
DecodeK = PICbyte And DC(B, 5)
tempC$ = " Move value of  " & DecodeK & " x 256 + 2nd byte to FSR" & DecodeF ' & " + 2nd byte to FSR" & DecodeF
AddressCode$ = PICdecode$
AddressCode2$ = DecodeF
PICdecode$ = Chr(9) & Chr(9) & Chr(9) & "  ; " & PICdecode$
PICdecode$ = PICdecode$ & tempC$
ma(DecodeK + 100) = 1:
'List2.AddItem DecodeK + 100
AddressVal1 = DecodeK
'LFSR    12:1110111000ffkkkk ' f,k   ' 1110 1110 00ff k11kkk ' 2nd  1111 0000 k7kkk  kkkk
'LFSR  -  Move literal (12-bit) 2nd word to FSRx 1st word

Case 13:
DecodeF = PICbyte And DC(B, 1)
If Reg$(DecodeF) = "" Then Reg$(DecodeF) = "REG" & Hex$(DecodeF)
tempC$ = " move value at " & Reg$(DecodeF) & " to file at 2nd byte address"
RegFlag(DecodeF) = 1
AddressCode$ = PICdecode$
AddressCode2$ = Reg$(DecodeF)
PICdecode$ = Chr(9) & Chr(9) & Chr(9) & "  ; " & PICdecode$
PICdecode$ = PICdecode$ & tempC$
'MOVFF   13:1100ffffffffffff ' fs,fd ' 1100 ffff ffff ffffs  ' 2nd  1111 ffff ffff   ffffd

Case 14:
DecodeN = PICbyte And DC(B, 6)
PICmsb$ = "H'" & Right$("0" + Hex$(DecodeN), 2) & "'"
PICdecode$ = PICdecode$ & Chr(9) & PICmsb$
'BRA     14:11010nnnnnnnnnnn ' n     ' 1101 0nnn nnnn nnnn
'RCALL   14:11011nnnnnnnnnnn ' n     ' 1101 1nnn nnnn nnnn
       
Case 15:
DecodeA = (PICbyte And DC(B, 3)) \ 256
DecodeB = (PICbyte And DC(B, 4)) \ 512
DecodeF = PICbyte And DC(B, 1)
tempC$ = Reg$(DecodeF): RegFlag(DecodeF) = 1
If Reg$(DecodeF) = "" Then tempC$ = "(UNFOUND) " & DecodeF: Unfound = 1
PICdecode$ = PICdecode$ & Chr(9) & tempC$ & "," & DecodeB & BSR$(DecodeA)
'BDC     15:1011b01afffff101 ' f,b,a ' BTFSC STATUS,DC: GOTO + DA$(3)
'BNDC    15:1010bb1afffff101 ' f,b,a ' BTFSS STATUS,DC: GOTO + DA$(3)

Case 16:
DecodeA = (PICbyte And DC(B, 3)) \ 256
DecodeB = (PICbyte And DC(B, 4)) \ 512
DecodeF = PICbyte And DC(B, 1)

tempD$ = DecodeB
If Reg$(DecodeF) = "STATUS" Then
If DecodeB = 0 Then tempD$ = "C"
If DecodeB = 1 Then tempD$ = "DC"
If DecodeB = 2 Then tempD$ = "Z"
End If

tempC$ = Reg$(DecodeF): RegFlag(DecodeF) = 1
If Reg$(DecodeF) = "" Then tempC$ = "(UNFOUND) " & DecodeF: Unfound = 1
PICdecode$ = PICdecode$ & Chr(9) & tempC$
'ADDCF   16:1011bb0afffff101 ' f,b,a ' BTFSC STATUS,C:  INCF + DA$(3), DA$(4)
'ADDDCF  16:1011bb1afffff101 ' f,b,a ' BTFSC STATUS,DC: INCF + DA$(3), DA$(4)

Case 17:
DecodeA = (PICbyte And DC(B, 3)) \ 256
DecodeB = (PICbyte And DC(B, 4)) \ 512
DecodeF = PICbyte And DC(B, 1)
tempC$ = Reg$(DecodeF): RegFlag(DecodeF) = 1
If Reg$(DecodeF) = "" Then tempC$ = "(UNFOUND) " & DecodeF: Unfound = 1
PICdecode$ = PICdecode$ & Chr(9) & tempC$ & "," & DecodeB & BSR$(DecodeA)
'SUBCF   17:1011b10afffff101 ' f,b,a ' BTFSC STATUS,C:  DECF + DA$(3), DA$(4)
'SUBDCF  17:1011bb1afffff101 ' f,b,a ' BTFSC STATUS,DC: DECF + DA$(3), DA$(4)

Case 18:
DecodeA = (PICbyte And DC(B, 3)) \ 256
DecodeB = (PICbyte And DC(B, 4)) \ 512
DecodeF = PICbyte And DC(B, 1)
tempC$ = Reg$(DecodeF): RegFlag(DecodeF) = 1
If Reg$(DecodeF) = "" Then tempC$ = "(UNFOUND) " & DecodeF: Unfound = 1
PICdecode$ = PICdecode$ & Chr(9) & tempC$ & "," & DecodeB & BSR$(DecodeA)
'TRIS    18:1000b11afffff101 ' 3,5,a ' BSF STATUS,5: MOVWF da$(3): BCF STATUS,5

Case 19:
DecodeA = (PICbyte And DC(B, 3)) \ 256
DecodeB = (PICbyte And DC(B, 4)) \ 512
DecodeF = PICbyte And DC(B, 1)
tempC$ = Reg$(DecodeF): RegFlag(DecodeF) = 1
If Reg$(DecodeF) = "" Then tempC$ = "(UNFOUND) " & DecodeF: Unfound = 1
PICdecode$ = PICdecode$ & Chr(9) & tempC$ & "," & DecodeB & BSR$(DecodeA)

'CLRC    19:1001bb0afffff101 ' f,b,a ' BCF STATUS,C
'CLRDC   19:1001bb1afffff101 ' f,b,a ' BCF STATUS,DC
'CLRZ    19:1001b10afffff101 ' f,b,a ' BCF STATUS,Z
'SETC    19:1000bb0afffff101 ' f,b,a ' BSF STATUS,C
'SETDC   19:1000bb1afffff101 ' f,b,a ' BSF STATUS,DC
'SETZ    19:1000b10afffff101 ' f,b,a ' BSF STATUS,Z
'SKPC    19:1010bb0afffff101 ' f,b,a ' BTFSS STATUS,C
'SKPDC   19:1010bb1afffff101 ' f,b,a ' BTFSS STATUS,DC
'SKPZ    19:1010b10afffff101 ' f,b,a ' BTFSS STATUS,Z
'SKPNC   19:1011bb0afffff101 ' f,b,a ' BTFSC STATUS,C
'SKPNDC  19:1011bb1afffff101 ' f,b,a ' BTFSC STATUS,DC
'SKPNZ   19:1011b10afffff101 ' f,b,a ' BTFSC STATUS,Z

Case 20:
DecodeK = PICbyte And DC(B, 5)
PICdecode$ = PICdecode$ & " " & DecodeK
'DATA    20:00001100kkkkkkkk ' k     ' RETLW  & DA$(3)

Case 21:
DecodeK = PICbyte And DC(B, 5)
PICdecode$ = PICdecode$ & " " & DecodeK
'B       21:11101111kkkkkkkk ' n     ' 1110 1111 k7kkk kkkk0 ' 2nd  1111 k19kkk kkkk kkkk8   ' k ' GOTO (ADDRESS)

Case 22:
DecodeA = (PICbyte And DC(B, 3)) \ 256
DecodeD = (PICbyte And DC(B, 2)) \ 512
If DecodeD = 0 Then Dest$ = "W" Else Dest$ = "F"
DecodeF = PICbyte And DC(B, 1)
tempC$ = Reg$(DecodeF): RegFlag(DecodeF) = 1
If Reg$(DecodeF) = "" Then tempC$ = "(UNFOUND) " & DecodeF: Unfound = 1
PICdecode$ = PICdecode$ & Chr(9) & tempC$ & "," & Dest$ & BSR$(DecodeA)
'MOVFW   22:010100daffffffff ' f,d,a ' MOVF & DA$(3) + ",W"

Case 23:
DecodeA = (PICbyte And DC(B, 3)) \ 256
DecodeD = (PICbyte And DC(B, 2)) \ 512
If DecodeD = 0 Then Dest$ = "W" Else Dest$ = "F"
DecodeF = PICbyte And DC(B, 1)
tempC$ = Reg$(DecodeF): RegFlag(DecodeF) = 1
If Reg$(DecodeF) = "" Then tempC$ = "(UNFOUND) " & DecodeF: Unfound = 1
PICdecode$ = PICdecode$ & Chr(9) & tempC$ & "," & Dest$ & BSR$(DecodeA)
'TSTF    23:010100daffffffff ' f,d,a ' "MOVF " & DA$(3) & ",F"
        
Case 24:
DecodeA = (PICbyte And DC(B, 3)) \ 256
DecodeD = (PICbyte And DC(B, 2)) \ 512
If DecodeD = 0 Then Dest$ = "W" Else Dest$ = "F"
DecodeF = PICbyte And DC(B, 1)
tempC$ = Reg$(DecodeF): RegFlag(DecodeF) = 1
If Reg$(DecodeF) = "" Then tempC$ = "(UNFOUND) " & DecodeF: Unfound = 1
PICdecode$ = PICdecode$ & Chr(9) & tempC$ & "," & Dest$ & BSR$(DecodeA)
'OPTION  24:1000b11afffff101 ' 3,5,a ' BSF STATUS,5: MOVWF OPTION_REG: BCF STATUS,5
        
Case 25:
DecodeA = (PICbyte And DC(B, 3)) \ 256
DecodeD = (PICbyte And DC(B, 2)) \ 512
If DecodeD = 0 Then Dest$ = "W" Else Dest$ = "F"
DecodeF = PICbyte And DC(B, 1)
tempC$ = Reg$(DecodeF): RegFlag(DecodeF) = 1
If Reg$(DecodeF) = "" Then tempC$ = "(UNFOUND) " & DecodeF: Unfound = 1
PICdecode$ = PICdecode$ & Chr(9) & tempC$ & "," & Dest$ & BSR$(DecodeA)
'RLF     25:001101daffffffff ' f,d,a ' 0011 01da ffff ffff  RLCF

Case 26:
DecodeA = (PICbyte And DC(B, 3)) \ 256
DecodeD = (PICbyte And DC(B, 2)) \ 512
If DecodeD = 0 Then Dest$ = "W" Else Dest$ = "F"
DecodeF = PICbyte And DC(B, 1)
tempC$ = Reg$(DecodeF): RegFlag(DecodeF) = 1
If Reg$(DecodeF) = "" Then tempC$ = "(UNFOUND) " & DecodeF: Unfound = 1
PICdecode$ = PICdecode$ & Chr(9) & tempC$ & "," & Dest$ & BSR$(DecodeA)
'RRF     26:001100daffffffff ' f,d,a ' 0011 00da ffff ffff  RRCF

Case 27:
DecodeK = PICbyte And DC(B, 5)
PICdecode$ = PICdecode$ & " " & DecodeK
'CLRW    27:00001110kkkkkkkk ' k     ' 0000 1110 kkkk kkkk  MOVLW 0
        
Case 28:

If PICbyte = 65535 Then
PICdecode$ = "Erased memory"
Else

DecodeK = (PICbyte And 4095)

If RTrim$(AddressCode$) = "movff" Then
PICdecode$ = AddressCode$ & Chr(9) & AddressCode2$ & "," & Reg$(DecodeK) & Chr(9) & "  ; 2nd byte = " & DecodeK
AddressVal1 = 0: AddressCode$ = ""
RegFlag(DecodeK) = 1
Exit Sub
End If

If RTrim$(AddressCode$) = "lfsr" Then
PICdecode$ = AddressCode$ & Chr(9) & AddressCode2$ & "," & (addresval1 * 256 + DecodeK) & Chr(9) & "  ; 2nd byte = " & DecodeK
AddressVal1 = 0: AddressCode$ = ""
Exit Sub
End If

If RTrim$(AddressCode$) = "goto" Then
X = (DecodeK And 255) * 256 + AddressVal1
PICdecode$ = AddressCode$ & Chr(9) & "JUMP" & X & Chr(9) & "  ; 2nd byte = " & DecodeK
ma(X + 100) = 1
Exit Sub
End If
 
If RTrim$(AddressCode$) = "call" Then
X = DecodeK * 256 + AddressVal1:
PICdecode$ = AddressCode$ & Chr(9) & "JUMP" & X & Chr(9) & "  ; 2nd byte = " & DecodeK
ma(X + 100) = 1
Exit Sub
End If

AddressVal1 = 0: AddressCode$ = ""

End If
        End Select

Exit Sub

showerror:
TK3ShowError.Show
Call TK3ShowError.waitresponse
Resume enderror
enderror:


End Sub

